	subroutine SHAPEQ(iout, idbg, Ne, Nn, V, D, Qce1, Qde1, &
			 ie, x, e)
! calculate nodal flux matrices

	implicit none
	integer iout, idbg
	integer Ne, Nn			! array parameters
	real*8 Qce1(2,2), Qde1(2,2)		! element arrays
	integer ie(Ne,3)			! global connectivity array
	real*8 x(Nn,1)				! global coordinates array
	real*8 V(Ne,1), D(Ne,1,1)		! global  arrays
	integer e

	integer i1, i2, m, k, ii, jj
	real*8 r, Jac, Jaci, dNdr(2,1), J(1,1), Ji(1,1)

!	write(idbg,'(a)') ' --- SHAPEQ ---'	! ### TEMPORARY ###

	i1 = ie(e,1)			! 1st node
	i2 = ie(e,2)			! 2nd node
	
! calculate the nodal advection flux matrix, Qce
	Qce1 = 0.	! reset Qce1
	do ii = 1,2
	  Qce1(ii,ii) = V(e,1)
	enddo		! ii	

! calculate the nodal conduction flux matrix, Qde
	Qde1 = 0.	! reset Qde1
	do ii = 1,2

! linear 1D shape functions
! Ni(r,s) = (1 +/- r) / 2 ; -1 < r < +1
	  if     (ii .eq. 1) then
	    r =-1.
	  else if(ii .eq. 2) then
	    r = 1.
	  endif

	  dNdr(1,1) =-0.5d0				! dN1(r)/dr
	  dNdr(2,1) = 0.5d0				! dN2(r)/dr

! Jij is the Jacobian matrix
	  J(1,1) = dNdr(1,1)*x(i1,1) + dNdr(2,1)*x(i2,1)	! x,r

	  Jac  = J(1,1)			! Jacobian determinant, |J|
	  Jaci = 1. / Jac					! 1/|J|

! inv(Jij)
	  Ji(1,1) = Jaci

	  do jj = 1,2
	    do m = 1,1		! direction loop
	      do k = 1,1	! direction loop
	        Qde1(ii,jj) = Qde1(ii,jj) - D(e,1,m) * dNdr(jj,k) * Ji(m,k)
	      enddo	! k	
	    enddo	! m	
	  enddo		! jj
	enddo		! ii

	return
	end
